
#---------------------------------------
# EE-BD-telo-table4-elife.R
#
# andrew mertens (amertens@berkeley.edu)
#
# The tabulate enrollment variables for 
# telomere manuscript table 4 - elife format
#---------------------------------------


rm(list=ls())
try(detach(package:plyr))
library(foreign)
library(dplyr)
library(washb)
library(tidyr)
library(reshape2)
library(xtable)

#load objects
setwd("C:/Users/andre/Dropbox/WASHB-EE-analysis/WBB-EE-analysis/Results/Andrew/")
load("telo_res.Rdata")

ts_t2_N_subgroup_M
ts_t3_N_subgroup_M
delta_ts_N_subgroup_M
delta_ts_subgroup_M
ts_t2_subgroup_M
ts_t3_subgroup_M



# Table functions
cleantable <- function(x,digits) {
 print( xtable(x,digits=digits),
        sanitize.text.function=function(y){y},
        floating=FALSE,
        include.rownames=FALSE,
        include.colnames=FALSE,
        only.contents=TRUE,
        hline.after=NULL
 )
}




table1_create<-function(mu, n, sd, mean.ind, vargroup, vargroup.row, Rownames, round){
  dat<-NULL
  for(j in 1:nrow(n)){
      if(mean.ind[j]==1){
      temp<-cbind(mu[j,1],sd[j,1],mu[j,2],sd[j,2])
      temp<-rnd(temp, 0)
      dat<-rbind(dat, temp)
      }else{
      temp<-cbind(n[j,1],(mu[j,1])*100,n[j,2],(mu[j,2])*100)
      temp<-rnd(temp, 0)
      dat<-rbind(dat, temp)
      }
  }
  rownames(dat)<-rownames(mu)

  col1<-NULL
  col2<-NULL
  for(j in 1:nrow(n)){
      if(mean.ind[j]==1){
      temp1<-cbind(paste(dat[j,1]," (",dat[j,2],")",sep=""))
      temp2<-cbind(paste(dat[j,3]," (",dat[j,4],")",sep=""))
      col1<-rbind(col1, temp1)
      col2<-rbind(col2, temp2)
      }else{
        if(j==1){
      temp1<-cbind(paste(dat[j,1],sep=""))
      temp2<-cbind(paste(dat[j,3],sep=""))
      col1<-rbind(col1, temp1)
      col2<-rbind(col2, temp2)           
        }else{
      temp1<-cbind(paste(dat[j,1]," (",dat[j,2],"\\%)",sep=""))
      temp2<-cbind(paste(dat[j,3]," (",dat[j,4],"\\%)",sep=""))
      col1<-rbind(col1, temp1)
      col2<-rbind(col2, temp2) 
        }
      }
  } 
  dat<-cbind(Rownames, col1, col2)
  colnames(dat)=c(" ","Control","Nutrition + WSH")
  return(dat)
}



glm_print<-function(obj, t=F, cols=c(1,3,4)){
  if(t==F){
        obj<-as.data.frame((obj))
  }else{
        obj<-as.data.frame(t(obj))
  }
  flag=F
  if(as.numeric(obj[6])<0.05){obj[6]<-paste0(sprintf("%1.3f",obj[c(6)]),"*")
                              flag=T}
  if(flag==F){
  obj<-t(as.matrix(c(sprintf("%1.2f",obj[cols]),
                     sprintf("%1.3f",obj[c(6)]))))    
  }else{
   obj<-t(as.matrix(c(sprintf("%1.2f",obj[cols]),
                     obj[c(6)])))       
  }

  #rownames(obj)<-colnames(obj)<-NULL
  out<-paste(obj[1],"(",obj[2],",",obj[3],") P=",obj[4], sep="")
  return(out)
}


#Function to round 0.5 away from zero (differs from R's default behavior)
round2 <- function(x, n=3) {
  posneg = sign(x)
  z = abs(x)*10^n
  z = z + 0.5
  z = trunc(z)
  z = z/10^n
  z*posneg
}
rnd<- function(x, n=2) {
  x<-round2(x,3)
  posneg = sign(x)
  z = abs(x)*10^n
  z = z + 0.5
  z = trunc(z)
  z = z/10^n
  z*posneg
}



 tab3 <- as.data.frame(matrix(NA, 6,8))
 tab3[,1] <- rep(c("Control", "N + WSH"),3)
 tab3[1:2,2] <- ts_t2_N_subgroup_M[1:2,3]
 tab3[1:2,3] <- ts_t2_N_subgroup_M[1:2,4]
 tab3[1:2,4] <- ts_t2_N_subgroup_M[3:4,3]
 tab3[1:2,5] <- ts_t2_N_subgroup_M[3:4,4]

 tab3[3:4,2] <- ts_t3_N_subgroup_M[1:2,3]
 tab3[3:4,3] <- ts_t3_N_subgroup_M[1:2,4]
 tab3[3:4,4] <- ts_t3_N_subgroup_M[3:4,3]
 tab3[3:4,5] <- ts_t3_N_subgroup_M[3:4,4]
 
 tab3[5:6,2] <- delta_ts_N_subgroup_M[1:2,3]
 tab3[5:6,3] <- delta_ts_N_subgroup_M[1:2,4]
 tab3[5:6,4] <- delta_ts_N_subgroup_M[3:4,3]
 tab3[5:6,5] <- delta_ts_N_subgroup_M[3:4,4]
 
 tab3[,3]<-rnd(tab3[,3],2)
 tab3[,5]<-rnd(tab3[,5],2)

tab3[2,6]<-glm_print(ts_t2_subgroup_M[1,-c(1)])
tab3[2,7]<-glm_print(ts_t2_subgroup_M[2,-c(1)])
tab3[4,6]<-glm_print(ts_t3_subgroup_M[1,-c(1)])
tab3[4,7]<-glm_print(ts_t3_subgroup_M[2,-c(1)])
tab3[6,6]<-glm_print(delta_ts_subgroup_M[1,-c(1)])
tab3[6,7]<-glm_print(delta_ts_subgroup_M[2,-c(1)])
tab3[6,6]<-glm_print(delta_ts_subgroup_M[1,-c(1)])
tab3[6,7]<-glm_print(delta_ts_subgroup_M[2,-c(1)])

tab3[2,8]<-glm_print(ts_t2_subgroup_fit[4,], cols=c(1:3))
tab3[4,8]<-glm_print(ts_t3_subgroup_fit[4,], cols=c(1:3))
tab3[6,8]<-glm_print(delta_ts_subgroup_fit[4,], cols=c(1:3))

tab3[c(1,3,5),6:8]<-""


blank=rep("",7)
tab3<-as.matrix(tab3)
tab3<-rbind(t(c("\\textbf{After 1 year of intervention (age \\textasciitilde 14 months)}",blank)),
            tab3[1:2,],
            t(c("\\textbf{After 2 years of intervention (age \\textasciitilde 28 months)}",blank)),
            tab3[3:4,],
            t(c("\\textbf{Change in telomere length}",blank)),
            tab3[5:6,])

setwd("C:/Users/andre/Dropbox/WASHB-EE-analysis/WBB-EE-analysis/Results/Tables/")
save(tab3, file="table3.RData")

cleantable(tab3, 2)



